<?php
namespace Trs\Migration\Storage;

use wpdb;


class WordpressOptionsStorage implements IStorage
{
    public function __construct(wpdb $wpdb)
    {
        $this->wpdb = $wpdb;
    }

    public function get($key, $default = null)
    {
        return get_option($key, $default);
    }

    public function set($key, $value, $autoload = null)
    {
        update_option($key, $value, $autoload);
    }

    public function findKeysLike($sqlLikePattern)
    {
        $query = $this->wpdb->prepare("
            SELECT `option_name` 
            FROM {$this->wpdb->options} 
            WHERE `option_name` LIKE %s",
        $sqlLikePattern);

        $keys = $this->wpdb->get_col($query, 0);

        return $keys;
    }

    public function escapeForLikePattern($string)
    {
        $this->wpdb->esc_like($string);
    }

    private $wpdb;
}